// kintoneカスタマイズ用JS
// 名称：合計値算出
// 機能：フィールドの合算値を表示します
// https://blog.winproject.jp/internet/kintone-get-total-specific-field/
// 2023/09/06,TT

(function() {
	"use strict";
	var getRecords = function(app, tmpRecords){
	var limit = 500;
	var tmpRecords = tmpRecords || [];

	return kintone.api(kintone.api.url('/k/v1/records', true), 'GET', {
				app: app,
				query: kintone.app.getQueryCondition() + ' limit ' + limit +' offset ' + tmpRecords.length
			}).then(function(response){
			tmpRecords = tmpRecords.concat(response.records);
			return response.records.length === limit ? getRecords(app, tmpRecords) : tmpRecords;
		});
	}
	kintone.events.on('app.record.index.show', function(event){
		getRecords(kintone.app.getId()).then(function(records) {

			var cnt = records.reduce(function(cnt, record) {				
				cnt = cnt + 1;
				return cnt;
			}, 0);

			var total = records.reduce(function(total, record) {				
				total = total + Number(record.price.value);	// price
				return total;
			}, 0);

			var html = "";
			html += '<div class="smart-chart">';
			html += '<table>';
			html += '<tr><td>件数</td><td>' + cnt.toLocaleString() + '件</td></tr>';
			html += '<tr><td>売上合計</td><td>¥' + total.toLocaleString() + '</td></tr>';
			html += '</table>';
			html += '</div>';

			kintone.app.getHeaderMenuSpaceElement().insertAdjacentHTML('beforeend', html);
		});
	});
})();

