// kintoneカスタマイズ用JS
// 名称：汎用曖昧検索
// 機能：文字列フィールドすべてを検索します
// https://blog.winproject.jp/internet/kintone-get-total-specific-field/
// 2023/09/02,TT

// 設定
//  検索対象フィールド（検索対象に含めたいフィールドを記述します）※文字列フィールドのみ
const FieldCodes = [    'name',   // 商品名
                        '_cat',   // _商品種別（検索用）※自動入力
                    ]; 

// メイン
(function() {
    'use strict';

    // 一覧画面でのみ使用のためレコード編集画面等では非表示とする
    kintone.events.on([
        'app.record.detail.show',
        'app.record.create.show',
        'app.record.edit.show',
        'app.record.print.show',
      ], function(event){
        kintone.app.record.setFieldShown('_likesearch', false); // 曖昧検索フィールドは非表示
        return event;
    });

    // 検索窓
    kintone.events.on("app.record.index.show", function (event) {

      // GET引数に格納された直前の検索キーワードを取得して再表示します
      var result = {};
      
      // クエリから、URL固定部分(?query=)を無視して取り出します
      var query = window.location.search.substring(7);  
      
      // フィールドコード名と検索キーワードに分割します
      for(var i = 0;i < query.length;i++){
          var element = query[i].split('like');
          var param_field_code = encodeURIComponent(element[0]);
          var param_search_word = encodeURIComponent(element[1]);

          //空白スペースを取り除いて配列に格納します
          result[param_field_code.replace(/^\s+|\s+$/g, "")] = param_search_word.replace(/^[\s|\"]+|[\s|\"]+$/g, "");
      }

      // 検索キーワード
      var search_word = document.createElement('input');
      search_word.type = 'text';

      // 検索ボタン
      var search_button = document.createElement('input');
      search_button.type = 'submit';
      search_button.value = '検　索';
      search_button.onclick = function () {
          keyword_search();
      };

      // キーワード検索の実行
      function keyword_search(){
          var keyword = search_word.value;
          var str_query = "";

          if(keyword == ""){
            str_query = "";
        }else if(keyword != ""){
            if(FieldCodes.length > 0) {

                // 検索対象のフィールドを全て「or」で連結してURLクエリを作成します
                str_query = '?query=';
                FieldCodes.forEach(function( value ) {
                    str_query = str_query + value +' like "' + keyword + '"';
                    str_query = str_query + ' or ';
                });
                str_query = str_query.slice(0, -4);　// 最後尾の「or」を削除しています
            }
          }

          // 検索結果のURLへ
          document.location = location.origin + location.pathname + str_query;
      }

      // 検索窓表示
      var node_space = kintone.app.getHeaderMenuSpaceElement()
      for (var i = node_space.childNodes.length - 1; i >= 0; i--) {
          node_space.removeChild(node_space.childNodes[i]);
      }
      var label = document.createElement('label');
      label.appendChild(document.createTextNode('  '));  
      label.appendChild(search_word);
      label.appendChild(document.createTextNode('  '));    
      label.appendChild(search_button);
      kintone.app.getHeaderMenuSpaceElement().appendChild(label);
     
      return event;
  });

})();
