jQuery.noConflict();

(function($, PLUGIN_ID) {
	'use strict';

	// プラグインIDを設定する
	const config = kintone.plugin.app.getConfig(PLUGIN_ID);

	// 設定値（config.isShowBorder）にすでに値が入ってたら、config.htmlの設定値入力欄にその値を入れる
	if (config.isShowNotice) {
		if(config.isShowNotice == 'check') {
			$("#js-isShowNotice").prop('checked', true);
		} else if(config.isShowNotice == 'uncheck') {
			$("#js-isShowNotice").prop('checked', false);
		} else {
			$("#js-isShowNotice").prop('checked', true);	// （一応、それ以外の値の場合はデフォルト値に）
		}
	} else {
		$("#js-isShowNotice").prop('checked', true);	// 設定に値がなければチェックありに（デフォルト）
	}
	if (config.isShowBorder) {
		if(config.isShowBorder == 'check') {
			$("#js-isShowBorder").prop('checked', true);
		} else if(config.isShowBorder == 'uncheck') {
			$("#js-isShowBorder").prop('checked', false);
		} else {
			$("#js-isShowBorder").prop('checked', true);	// （一応、それ以外の値の場合はデフォルト値に）
		}
	} else {
		$("#js-isShowBorder").prop('checked', true);	// 設定に値がなければチェックありに（デフォルト）
	}

	// config.htmlの保存するボタンおしたら
	// プラグインに設定値入力欄の値を保存し
	// メッセージを表示後、アプリ設定画面へ遷移させる
	$('.js-submit-settings').on('submit', function(e) {
		e.preventDefault();
		let config = {};
		if($('#js-isShowNotice').prop('checked')) {
			config.isShowNotice = 'check';
		} else {
			config.isShowNotice = 'uncheck';
		}
		if($('#js-isShowBorder').prop('checked')) {
			config.isShowBorder = 'check';
		} else {
			config.isShowBorder = 'uncheck';
		}
		kintone.plugin.app.setConfig(config, function() {
			alert('プラグインの設定を更新しました、アプリ設定に戻り[アプリを更新]をクリックしてください');
			window.location.href = '../../flow?app=' + kintone.app.getId();
		});
	});
	
	// config.htmlのキャンセルボタンおしたら
	// プラグイン設定画面に遷移させる
	$('.js-cancel-button').on('click', function() {
		window.location.href = '../../' + kintone.app.getId() + '/plugin/';
	});

})(jQuery, kintone.$PLUGIN_ID);
