jQuery.noConflict();

(function($, PLUGIN_ID) {
	'use strict';

	// 一覧画面でのみ使用のためレコード編集画面等では非表示とする
	kintone.events.on([
		'app.record.detail.show',
		'app.record.create.show',
		'app.record.edit.show',
		'app.record.print.show',
	], function(event){
		// kintone.app.record.setFieldShown('_likesearch', false); // 曖昧検索フィールドは非表示
		return event;
	});

	// 検索窓
	kintone.events.on("app.record.index.show", async function (event) {

		/* --------------------------------
		*	フィールド情報の取得
		*/
		const fieldCodes = [];			// フィールドコード配列
		const fieldSearchMethod = [];	// フィールド検索形式配列
			
		// REST APIでレイアウトの情報を取得
		const body = {
			app: kintone.app.getId(),
		}
		const data = await kintone.api(kintone.api.url('/k/v1/app/form/layout.json', true), 'GET', body);
		getLayout(data.layout, fieldCodes, fieldSearchMethod);
		// console.log("fieldCodes, fieldSearchMethod:", fieldCodes, fieldSearchMethod);

		function getLayout(layout, fieldCodes, fieldSearchMethod) {
			// console.log("layout:", layout);
			layout.forEach((item) => {
				if (item.type === 'ROW' || item.type === 'SUBTABLE') {
					item.fields.forEach((field) => {
						// console("field", field);
						if (field.code) {
							// 文字列フィールドの場合のみ検索対象として格納
							// 参考 https://cybozu.dev/ja/kintone/docs/overview/field-types/#field-type
							// console.log("field.code, field.type:", field.code, field.type);
							switch (field.type) {
								/*
								// レコード情報に関するフィールド
								RECORD_NUMBER	// レコード番号
								__ID__	// レコードID
								__REVISION__	// リビジョン
								CREATOR	// 作成者
								CREATED_TIME	// 作成日時
								MODIFIER	// 更新者
								UPDATED_TIME	// 更新日時
								*/
								// カスタムフィールド
								case 'SINGLE_LINE_TEXT':	// 文字列
								case 'MULTI_LINE_TEXT':		// 文字列（複数行）
								case 'RICH_TEXT':			// リッチエディター
									fieldCodes.push(field.code);
									//console("field.label", field.label);
									fieldSearchMethod.push('LIKE');		// （文字列フィールドはlikeで検索します）
									break;
								case 'NUMBER':				// 数値
									fieldCodes.push(field.code);
									if(item.type === 'SUBTABLE') {
										fieldSearchMethod.push('IN');		// （テーブル内の数値フィールドはinで検索します）
									} else {
										fieldSearchMethod.push('EQ');		// （数値フィールドは=で検索します）
									}
									break;
								case 'CALC':				// 計算
								case 'CHECK_BOX':			// チェックボックス
								case 'RADIO_BUTTON':		// ラジオボタン
								case 'MULTI_SELECT':		// 複数選択
								case 'DROP_DOWN':			// ドロップダウン
								case 'USER_SELECT':			// ユーザー選択
								case 'ORGANIZATION_SELECT':	// 組織選択
								case 'GROUP_SELECT':		// グループ選択
								case 'DATE':				// 日付
								case 'TIME':				// 時刻
								case 'DATETIME':			// 日時
								case 'LINK':				// リンク
								case 'FILE':				// 添付ファイル
								case 'SINGLE_LINE_TEXT':	// ルックアップ
								case 'SUBTABLE':			// テーブル
								case 'REFERENCE_TABLE':		// 関連レコード一覧 ※値の取得はできない
								case 'CATEGORY':			// カテゴリー
								case 'STATUS':				// ステータス
								case 'STATUS_ASSIGNEE':		// 作業者
								case 'LABEL':				// ラベル ※値の取得はできない
								case 'SPACER':				// スペース ※値の取得はできない
								case 'HR':					// 罫線 ※値の取得はできない
								case 'GROUP':				// グループ ※値の取得はできない
								default:
									break;
							}
						}
					});
				} else {
					getLayout(item.layout, fieldCodes, fieldSearchMethod);
				}
			});
		}
		/* -------------------------------- */

		
		/* --------------------------------
		*	フィールド情報を元に検索
		*/
		// キーワード検索窓の表示
		// （説明文）
		let notice = "";
		for(let i = 0; i < fieldCodes.length; i++) notice += "「" + fieldCodes[i] + "」 "; 
		notice = notice + "から検索できます";
		var search_notice = document.createElement('p');
		search_notice.appendChild(document.createTextNode(notice));

		// （検索窓）
		var search_word = "";	// GET引数に格納された直前の検索キーワードを取得して再表示用
		var query = window.location.search.substring(7);	// クエリから、URL固定部分(?query=)を無視して取り出す
		// console.log("query:", query);
		query = decodeURI(query);
		// console.log("query2:", query);
		if(query != "") {
			let seaches = query.split(' or ');
			for(let i = 0;i < seaches.length;i++){
				// console.log("seaches:", seaches);
				let word = seaches[i].split(' like ');	// 例「名称 like "電気"」
				// console.log("word:", word);
				if(word.length > 1) search_word = word[1].replace(/\"/g, "");	// 例「電気」
				if(search_word != "") break;
			}
		}
		// console.log("search_word:", search_word);
		var search_input = document.createElement('input');
		search_input.type = 'text';
		search_input.value = search_word;	// （初期値、先程検索したものがあればその文字列を表示）

		// （検索ボタン）
		var search_button = document.createElement('input');
		search_button.type = 'submit';
		search_button.value = '簡易検索';
		search_button.onclick = function () {
			keyword_search(fieldCodes);
		};

		// （クリアボタン）
		var clear_button = document.createElement('input');
		clear_button.type = 'submit';
		clear_button.value = 'クリア';
		clear_button.onclick = function () {
			const clearFieldCodes = [];
			keyword_search(clearFieldCodes);
		};

		// （表示）
		var node_space = kintone.app.getHeaderMenuSpaceElement()
		for (var i = node_space.childNodes.length - 1; i >= 0; i--) {
			node_space.removeChild(node_space.childNodes[i]);
		}
		var elem = document.createElement('div');
		elem.className = 'smart-search';
		elem.appendChild(search_notice);
		elem.appendChild(search_input);
		elem.appendChild(search_button);
		elem.appendChild(clear_button);
		kintone.app.getHeaderMenuSpaceElement().appendChild(elem);

		// 表示オプションの取得と反映
		const config = kintone.plugin.app.getConfig(PLUGIN_ID);
		let isShowNotice = true;	// デフォルトはtrue
		if(config.isShowNotice == 'check') {
			isShowNotice = true;
		} else if(config.isShowNotice == 'uncheck') {
			isShowNotice = false;
		}
		let isShowBorder = true;	// デフォルトはtrue
		if(config.isShowBorder == 'check') {
			isShowBorder = true;
		} else if(config.isShowBorder == 'uncheck') {
			isShowBorder = false;
		}
		// console.log("isShowNotice:", isShowNotice);
		// console.log("isShowBorder:", isShowBorder);
		if(isShowNotice) {
			$('div.smart-search p').css({'display':'block'});
		} else {
			$('div.smart-search p').css({'display':'none'});
		}
		if(isShowBorder) {
			$('div.smart-search').css({'border':'1px solid #3498db','padding':'0 0.8em'});
		} else {
			$('div.smart-search').css({'border':'none','padding':'0'});			
		}

		// キーワード検索の実行
		function keyword_search(fieldCodes) {
			// console.log(" - fieldCodes:", fieldCodes);
			var keyword = search_input.value;
			var str_query = "";

			if (keyword == "") {
				str_query = "";
			} else if (keyword != "") {
				if(fieldCodes.length > 0) {
					// 検索対象のフィールドを全て「or」で連結してURLクエリを作成します
					var i = 0;
					str_query = '?query=';
					fieldCodes.forEach(function( value ) {
						if(fieldSearchMethod[i] == 'LIKE') {
							str_query += value +' like "' + keyword + '" or ';
						} else if(fieldSearchMethod[i] == 'EQ') {
							str_query += value +' = "' + keyword + '" or ';
						} else if(fieldSearchMethod[i] == 'IN') {
							str_query += value +' in ("' + keyword + '") or ';
						}
						i++;
					});
					str_query = str_query.slice(0, -4);　// （最後尾の「or」を削除しています）
				}
			}

			// 検索結果のURLへ
			document.location = location.origin + location.pathname + str_query;
		}
		/* -------------------------------- */

		return event;
	});
})(jQuery, kintone.$PLUGIN_ID);
