// 設定画面用js
// 	設定画面では下記のオプションを設定することができます。
//	・検索対象フィールドコードの表示の有無（デフォルトは非表示です）
//	・枠線の表示の有無（デフォルトは表示です）
//	・ボタン名「クリア」の表示テキスト（デフォルトは「クリア」）
//	・検索の対象に含めないフィールドコード（複数の場合はカンマで区切って列記）
//
jQuery.noConflict();

(function($, PLUGIN_ID) {
	'use strict';

	// プラグインIDを設定する
	const config = kintone.plugin.app.getConfig(PLUGIN_ID);

	// 設定値（config.isShowBorder）にすでに値が入ってたら、config.htmlの設定値入力欄にその値を入れる
	//	・検索対象フィールドコードの表示の有無（デフォルトは非表示です）
	if (config.isShowNotice) {
		if(config.isShowNotice == 'check') {
			$("#js-isShowNotice").prop('checked', true);
		} else if(config.isShowNotice == 'uncheck') {
			$("#js-isShowNotice").prop('checked', false);
		} else {
			$("#js-isShowNotice").prop('checked', false);	// （一応、それ以外の値の場合はデフォルト値に）
		}
	} else {
		$("#js-isShowNotice").prop('checked', false);	// 設定に値がなければチェックなしに（デフォルト）
	}

	//	・枠線の表示の有無（デフォルトは表示です）
	if (config.isShowBorder) {
		if(config.isShowBorder == 'check') {
			$("#js-isShowBorder").prop('checked', true);
		} else if(config.isShowBorder == 'uncheck') {
			$("#js-isShowBorder").prop('checked', false);
		} else {
			$("#js-isShowBorder").prop('checked', true);	// （一応、それ以外の値の場合はデフォルト値に）
		}
	} else {
		$("#js-isShowBorder").prop('checked', true);	// 設定に値がなければチェックありに（デフォルト）
	}

	//	・ボタン名「検索」の表示テキスト（デフォルトは「検索」）
	if (config.buttonName_Search) {
		$("#js-buttonName_Search").val(config.buttonName_Search);
	} else {
		$("#js-buttonName_Search").val('検索');	// （設定に値がなければデフォルト値に）
	}

	//	・ボタン名「クリア」の表示テキスト（デフォルトは「ｸﾘｱ」）
	if (config.buttonName_Clear) {
		$("#js-buttonName_Clear").val(config.buttonName_Clear);
	} else {
		$("#js-buttonName_Clear").val('ｸﾘｱ');	// （設定に値がなければデフォルト値に）
	}

	//	・検索の対象に含めないフィールドコード（複数の場合はカンマで区切って列記）
	if (config.noSearcFields) {
		$("#js-noSearcFields").val(config.noSearcFields);
	} else {
		$("#js-noSearcFields").val('');	// （設定に値がなければデフォルト値に）
	}

	// config.htmlの保存するボタンおしたら
	// プラグインに設定値入力欄の値を保存し
	// メッセージを表示後、アプリ設定画面へ遷移させる
	$('.js-submit-settings').on('submit', function(e) {
		e.preventDefault();
		let config = {};
		if($('#js-isShowNotice').prop('checked')) {
			config.isShowNotice = 'check';
		} else {
			config.isShowNotice = 'uncheck';
		}
		if($('#js-isShowBorder').prop('checked')) {
			config.isShowBorder = 'check';
		} else {
			config.isShowBorder = 'uncheck';
		}
		if($("#js-buttonName_Search").val()) {
			config.buttonName_Search = $("#js-buttonName_Search").val();
		}
		if($("#js-buttonName_Clear").val()) {
			config.buttonName_Clear = $("#js-buttonName_Clear").val();
		}
		if($("#js-noSearcFields").val()) {
			config.noSearcFields = $("#js-noSearcFields").val();
		}
		kintone.plugin.app.setConfig(config, function() {
			alert('プラグインの設定を更新しました、アプリ設定に戻り[アプリを更新]をクリックしてください');
			window.location.href = '../../flow?app=' + kintone.app.getId();
		});
	});
	
	// config.htmlのキャンセルボタンおしたら
	// プラグイン設定画面に遷移させる
	$('.js-cancel-button').on('click', function() {
		window.location.href = '../../' + kintone.app.getId() + '/plugin/';
	});

})(jQuery, kintone.$PLUGIN_ID);
