// カンタン検索プラグインjs
//
// 	kintoneにカンタン検索機能を提供します
// 	
// 	設定画面により下記のオプションを設定できます（※設定画面jsはconfig.js）
// 	・検索対象フィールドコードの表示の有無（デフォルトは非表示です）
// 	・枠線の表示の有無（デフォルトは表示です）
// 	・検索ボタンに表示するテキスト（デフォルトは「検索」）
// 	・クリアボタンに表示するテキスト（デフォルトは「ｸﾘｱ」）
// 	・検索の対象に含めないフィールド（フィールドコードをカンマで区切って列記してください）
//
// 20231103, t2, https://blog.winproject.jp/internet/kantansearch-kintoneplugin/
// 20231106, t2, バージョン1.2 ルックアップ（tyle LINK）のフィールドも検索に含めるようにしました
//
jQuery.noConflict();

(function($, PLUGIN_ID) {
	'use strict';

	// 一覧画面でのみ使用のためレコード編集画面等では非表示とする
	kintone.events.on([
		'app.record.detail.show',
		'app.record.create.show',
		'app.record.edit.show',
		'app.record.print.show',
	], function(event){
		// kintone.app.record.setFieldShown('_likesearch', false); // 曖昧検索フィールドは非表示
		return event;
	});

	// 検索
	kintone.events.on("app.record.index.show", async function (event) {
		try {
			/* --------------------------------
			*	フィールド情報の取得
			*/
			const fieldCodes = [];			// フィールドコード配列
			const fieldSearchMethod = [];	// フィールド検索形式配列
			const fieldSearchOptions = [];	// フィールド検索限定語句配列（DROP_DOWNの時には該当する項目以外を検索するとエラーとなるため参照用に格納）
				
			// REST APIでレイアウトの情報を取得
			const body = {
				app: kintone.app.getId(),
			}

			await kintone.api(kintone.api.url('/k/v1/form', true), 'GET', body, (resp) => {
				// console.log("resp:", resp);
				// console.log("resp.properties:", resp.properties);			
				getProperties(resp.properties, fieldCodes, fieldSearchMethod, fieldSearchOptions, false);
				// console.log("fieldCodes:", fieldCodes);
				// console.log("fieldSearchMethod:", fieldSearchMethod);
				// console.log("fieldSearchOptions:", fieldSearchOptions);
			}, (error) => {
				console.log(error);
			});
			
			function getProperties(properties, fieldCodes, fieldSearchMethod, fieldSearchOptions, isSubtable) {
				properties.forEach((field) => {
					// console.log("field:", field);
					// console.log("field.code:", field.code);
					// console.log("field.type:", field.type);
					if (field.code) {
						switch (field.type) {
							// レコード情報に関するフィールド --------
							/*
							（レコード情報に関するフィールドは上記fieldに入ってこないので一旦スルーしておきます
							　もし実装する場合は管理画面で「レコードIDも検索に含める」にチェックを入れるなどの
							　実装方法にする必要があります。）
							case '__ID__':				// レコードID
								fieldCodes.push(field.code);
								fieldSearchMethod.push('EQ');		// （数値フィールドは=で検索します）								
								fieldSearchOptions.push('');
								break;
							*/
							// __REVISION__	// リビジョン
							// RECORD_NUMBER		// レコード番号
							// CREATOR	// 作成者
							// CREATED_TIME	// 作成日時
							// MODIFIER	// 更新者
							// UPDATED_TIME	// 更新日時

							// カスタムフィールド --------
							case 'SINGLE_LINE_TEXT':	// 文字列
							case 'MULTI_LINE_TEXT':		// 文字列（複数行）
							case 'RICH_TEXT':			// リッチエディター
							case 'LINK':				// ルックアップ
								fieldCodes.push(field.code);
								fieldSearchMethod.push('LIKE');		// （文字列フィールドはlikeで検索します）
								fieldSearchOptions.push('');
								break;
							case 'NUMBER':				// 数値
							case 'CALC':				// 計算
								fieldCodes.push(field.code);
								if(isSubtable) {
									fieldSearchMethod.push('IN');		// （テーブル内の数値フィールドはinで検索します）
								} else {
									fieldSearchMethod.push('EQ');		// （数値フィールドは=で検索します）								
								}
								fieldSearchOptions.push('');
								break;
							case 'CHECK_BOX':			// チェックボックス
							case 'RADIO_BUTTON':		// ラジオボタン
							case 'MULTI_SELECT':		// 複数選択
							case 'DROP_DOWN':			// ドロップダウン
								fieldCodes.push(field.code);
								fieldSearchMethod.push('IN2');		// （ドロップダウンフィールドはinで検索しますが、検索実行時に項目が実際にあるかのチェックが必要なため、検索時に上記のINとは区別して処理しています）
								fieldSearchOptions.push(field.options.toString());
								break;

							// サブテーブル内 --------
							case 'SUBTABLE':			// サブテーブルの場合
								// console.log("SUBTABLE -----");
								// console.log("field.fields:", field.fields);
								getProperties(field.fields, fieldCodes, fieldSearchMethod, fieldSearchOptions, true);
								break;

							// その他のフィールド --------
							case 'USER_SELECT':			// ユーザー選択
							case 'ORGANIZATION_SELECT':	// 組織選択
							case 'GROUP_SELECT':		// グループ選択
							case 'DATE':				// 日付
							case 'TIME':				// 時刻
							case 'DATETIME':			// 日時
							case 'FILE':				// 添付ファイル
							case 'REFERENCE_TABLE':		// 関連レコード一覧 ※値の取得はできない
							case 'CATEGORY':			// カテゴリー
							case 'STATUS':				// ステータス
							case 'STATUS_ASSIGNEE':		// 作業者
							case 'LABEL':				// ラベル ※値の取得はできない
							case 'SPACER':				// スペース ※値の取得はできない
							case 'HR':					// 罫線 ※値の取得はできない
							case 'GROUP':				// グループ ※値の取得はできない
							default:
								break;
						}
					} else {
						//
					}
				});
			}
			/* -------------------------------- */

			
			/* --------------------------------
			*	フィールド情報を元に検索
			*/
			// オプションの取得
			const config = kintone.plugin.app.getConfig(PLUGIN_ID);

			// 検索除外フィールドの取得
			let noSearcFields = [];
			if(config.noSearcFields) {
				noSearcFields = config.noSearcFields.split(',');
			}

			// キーワード検索窓の表示
			// （説明文）
			let notice = "";
			for(let i = 0; i < fieldCodes.length; i++) notice += "「" + fieldCodes[i] + "」 "; 
			notice = notice + "から検索できます";
			var search_notice = document.createElement('p');
			search_notice.appendChild(document.createTextNode(notice));

			// （検索窓）
			var search_word = "";	// GET引数に格納された直前の検索キーワードを取得して再表示用
			var query = window.location.search.substring(7);	// クエリから、URL固定部分(?query=)を無視して取り出す
			query = decodeURI(query);
			if(query != "") {
				let seaches = query.split(' or ');
				for(let i = 0;i < seaches.length;i++){
					let word = seaches[i].split(' like ');	// 例「名称 like "電気"」
					if(word.length > 1) search_word = word[1].replace(/\"/g, "");	// 例「電気」
					if(search_word != "") break;
				}
			}
			// console.log("search_word:", search_word);
			var search_input = document.createElement('input');
			search_input.type = 'text';
			search_input.value = search_word;	// （初期値、先程検索したものがあればその文字列を表示）

			// （検索ボタン）
			var search_button = document.createElement('input');
			search_button.type = 'submit';
			search_button.value = config.buttonName_Search;
			search_button.onclick = function () {
				keyword_search(fieldCodes, noSearcFields);
			};

			// （クリアボタン）
			var clear_button = document.createElement('input');
			clear_button.type = 'submit';
			clear_button.value = config.buttonName_Clear;
			clear_button.onclick = function () {
				keyword_search([], []);
			};

			// （表示）
			var node_space = kintone.app.getHeaderMenuSpaceElement()
			for (var i = node_space.childNodes.length - 1; i >= 0; i--) {
				node_space.removeChild(node_space.childNodes[i]);
			}
			var elem = document.createElement('div');
			elem.className = 'kantansearch';
			elem.appendChild(search_notice);
			elem.appendChild(search_input);
			elem.appendChild(search_button);
			elem.appendChild(clear_button);
			kintone.app.getHeaderMenuSpaceElement().appendChild(elem);

			// 表示オプションの取得と反映
			let isShowNotice = true;	// デフォルトはtrue
			if(config.isShowNotice == 'check') {
				isShowNotice = true;
			} else if(config.isShowNotice == 'uncheck') {
				isShowNotice = false;
			}
			let isShowBorder = true;	// デフォルトはtrue
			if(config.isShowBorder == 'check') {
				isShowBorder = true;
			} else if(config.isShowBorder == 'uncheck') {
				isShowBorder = false;
			}
			if(isShowNotice) {
				$('div.kantansearch p').css({'display':'block'});
			} else {
				$('div.kantansearch p').css({'display':'none'});
			}
			if(isShowBorder) {
				$('div.kantansearch').css({'border':'1px solid #3498db','padding':'0 0.8em'});
			} else {
				$('div.kantansearch').css({'border':'none','padding':'0'});			
			}

			// キーワード検索の実行
			// （引数：フィールド配列、検索除外フィールド配列）
			function keyword_search(fieldCodes, noSearcFields) {
				// console.log(" - fieldCodes:", fieldCodes);
				var keyword = search_input.value;
				var str_query = "";
				var query = ""

				if (keyword == "") {
					str_query = "";
				} else if (keyword != "") {

					// 検索の実行
					if(fieldCodes.length > 0) {
						// 検索対象のフィールドを全て「or」で連結してURLクエリを作成します
						var i = 0;
						str_query = '?query=';
						fieldCodes.forEach(function( value ) {
							if(! noSearcFields.includes(value)) {	// 除外フィールドでなければ検索対象としてクエリに加える
								if(fieldSearchMethod[i] == 'LIKE') {
									str_query += value +' like "' + keyword + '" or ';
								} else if(fieldSearchMethod[i] == 'EQ') {
									str_query += value +' = "' + keyword + '" or ';
								} else if(fieldSearchMethod[i] == 'IN') {
									str_query += value +' in ("' + keyword + '") or ';
								} else if(fieldSearchMethod[i] == 'IN2') {	// DROP_DOWN等では項目がある場合のみ検索する
									const optionsArray = fieldSearchOptions[i].split(',');
									if(optionsArray.includes(keyword)) {
										str_query += value +' in ("' + keyword + '") or ';
									}
								}
							}
							i++;
						});
						query = str_query.slice(0, -4);　// （最後尾の「or」を削除しています）
					}
				}

				// 検索結果のURLへ
				// console.log("query:", query);
				// setTimeout(function () { document.location = location.origin + location.pathname + query; }, 10000); 
				document.location = location.origin + location.pathname + query;	
			}
			/* -------------------------------- */

			return event;
		} catch (error) {
			// console.log("catch error.");
			console.log(error);
		}
	});
})(jQuery, kintone.$PLUGIN_ID);
